DEFSNG A-Z
OPTION BASE 1
' $INCLUDE: 'LCOMMON.BAS'
DECLARE FUNCTION DBLMIN#(A#,B#)
DECLARE FUNCTION DBLMAX#(A#,B#)
'trap routine for I/O error
7790	BEEP
	INPUT "DEVICE ERROR - HIT ENTER TO RETRY",IDUM$
	ECODE%=1
	RESUME NEXT
'ERROR TRAP ON OPENING DIGITIZER
8260	IF ERR<>57 THEN
		CLS
		PRINT "UNKNOWN ERROR OPENING DIGITIZER. BASIC CODE= ";ERR
		PRINT "HIT ANY KEY TO RETRY"
		IDUM$=INPUT$(1)
	ELSE
		CLS
		PRINT "DEVICE I/O ERROR OPENING DIGITIZER - RETRYING"
	END IF
	ECODE%=1
	RESUME NEXT
'ERROR ROUTINE FOR OPENING PROJECTION PARAMETERS FILE
8750	PRINT "AN ERROR HAS OCCURRED OPENING PROJECTION PARAMETERS FILE"
	PRINT "RETURNING TO ALLOW RE-ENTRY."
	ECODE%=1
	RESUME NEXT
SUB DigitizeLocations(FILNAM$) STATIC
' $DYNAMIC
DIM DGWLL#(6,2),ICHR$(16),OCHR$(16)
' $STATIC
'Digitize new well locations
' 
	OPEN "CONFIG.DIG" FOR INPUT AS #1
	INPUT #1,DIGITIZER$
	INPUT #1,CPOS%,CWID%
	INPUT #1,XPOS%,XWID%,XUNIT
	INPUT #1,YPOS%,YWID%,YUNIT
	INPUT #1,DIGKEY%
	FOR I%=1 TO DIGKEY%
		INPUT #1,ICHR$(I%),OCHR$(I%)
	NEXT I%
	CLOSE #1
	CSCR$=SPACE$(78)
	CLS
'go setup latitude-longitude to xy projection parameters
DPR1:	ECODE%=0
	CALL TTINAA(1,1,"ENTER FILENAME OF PROJECTION PARAMETERS: ",TEMP$,PRJNAM$,"Y")
	PRJNAM$=TEMP$
	ON ERROR GOTO 8750
	OPEN PRJNAM$ FOR INPUT AS #5
	ON ERROR GOTO 0
	IF ECODE%=1 GOTO DPR1
	ECODE%=0
	CALL SetupProjection(PTYP%,DARRAY#(),CM#,ECODE%)
	IF ECODE%=1 THEN
		PRJNAM$=""
		GOTO DPR1
	END IF
	CALL OpenFiles(FILNAM$)
	CALL ReadFirst(NoOfWells,FirstRecord,FinalRecord,NNV,TITLE$,DBWLL#())
	CALL TTINAA(0,0,"ARE THE DATA BASE CORNERS THE CORNERS OF THIS MAP?(Y/N): ",IANS$,"","Y")
	IANS$=UCASE$(IANS$)
	IF IANS$="Y" THEN
		FOR I%=1 TO 4
			DGWLL#(I%,1)=DBWLL#(I%,1)
			DGWLL#(I%,2)=DBWLL#(I%,2)
		NEXT I%
	ELSE
' $DYNAMIC
		DIM MAPTYP$(5),DELTA(4,2)
' $STATIC
		MAPTYP$(1)=" 7 1/2 MINUTE"
		MAPTYP$(2)=" 15 MINUTE"
		MAPTYP$(3)=" 30 MIN LAT x 1 DEG LONG"
		MAPTYP$(4)=" 1 DEG LAT x 2 DEG LONG"
		MAPTYP$(5)=" OTHER"
		DELTA(1,1)=.125
		DELTA(1,2)=.125
		DELTA(2,1)=.25
		DELTA(2,2)=.25
		DELTA(3,1)=.5
		DELTA(3,2)=1.0
		DELTA(4,1)=1.0
		DELTA(4,2)=2.0
MT:		PRINT "TYPES OF MAPS"
		PRINT
		FOR I% = 1 TO 5
			PRINT STR$(I%)+" - "+MAPTYP$(I%)
		NEXT I%
		PRINT
		CALL TTINSI(0,0,"ENTER TYPE: ",TYP%,0,"Y")
		IF TYP%<1 OR TYP%>5 THEN
			LOCATE 25,1
			PRINT "INVALID TYPE OF MAP - HIT ANY KEY TO CONTINUE";
			IDUM$=INPUT$(1)
			LOCATE 25,1
			PRINT CSCR$;
			GOTO MT
		END IF
SPIN:		PRINT "ENTER LAT/LON OF NORTHWEST CORNER"
		CALL CORNER(IU%,"N",DGWLL#(1,1),DGWLL#(1,2))
		IF TYP%>=1 AND TYP%<=4 THEN
			M1=3600.0D0*ABS(DGWLL#(1,1))
			M2=3600.0D0*ABS(DELTA(TYP%,1))
			MLAT%=INT(M1/M2)
			MLAT=ABS(DGWLL#(1,1))-MLAT%*DELTA(TYP%,1)
			M1=3600.0D0*ABS(DGWLL#(1,2))
			M2=3600.0D0*ABS(DELTA(TYP%,2))
			MLON%=INT(M1/M2)
			MLON=ABS(DGWLL#(1,2))-MLON%*DELTA(TYP%,2)
			IF MLAT<>0 OR MLON<>0 THEN
				PRINT "INVALID COORDINATE FOR THIS TYPE OF MAP"
				PRINT "NOT MULTIPLE OF ";DELTA(TYP%,1);" BY ";DELTA(TYP%,2); "DEGREES"
				PRINT "CHECK AND RE-ENTER"
				GOTO SPIN
			END IF
			DGWLL#(2,1)=DGWLL#(1,1)-DELTA(TYP%,1)
			DGWLL#(2,2)=DGWLL#(1,2)
			DGWLL#(3,1)=DGWLL#(2,1)
			DGWLL#(3,2)=DGWLL#(1,2)+DELTA(TYP%,2)
			DBWLL#(4,1)=DGWLL#(1,1)
			DGWLL#(4,2)=DGWLL#(3,2)
		ELSEIF TYP%= 5 THEN
			PRINT "ENTER LAT/LON OF SOUTHWEST CORNER"
			CALL CORNER(IU%,"N",DGWLL#(2,1),DGWLL#(2,2))
			PRINT "ENTER LAT/LON OF SOUTHEAST CORNER"
			CALL CORNER(IU%,"N",DGWLL#(3,1),DGWLL#(3,2))
			PRINT "ENTER LAT/LON OF NORTHEAST CORNER"
			CALL CORNER(IU%,"N",DGWLL#(4,1),DGWLL#(4,2))
		END IF
ERASE MAPTYP$,DELTA
	END IF
	CLS
	PRINT "FOLLOWING QUESTIONS APPLY TO WELL ID MASK(MAX OF 12 CHARS TOTAL)"
	LOCATE 25,1
	PRINT CSCR$;
	LOCATE 25,1
	PRINT "WELL ID CAN HAVE A MAX. TOTAL OF 12 CHARACTERS";
LP3:	LOCATE 1,1
	CALL TTINAA(2,1,"ENTER PREFIX: ",PREFIX$,"","Y")
	CALL TTINSI(3,1,"MAXIMUM NO. OF DIGITS: ",ND%,0,"Y")
	CALL TTINAA(4,1,"ENTER SUFFIX: ",SUFFIX$,"","Y")
	LMASK%=LEN(PREFIX$)+ND%+LEN(SUFFIX$)
	IF LMASK%>12 THEN
		BEEP
		GO TO LP3
	END IF 
	CLS
	MINLAT#=1.0D23
	MAXLAT#=-1.0*MINLAT#
	FOR I%=1 TO 4
		MINLAT#=DBLMIN#(MINLAT#,DGWLL#(I%,1))
		MAXLAT#=DBLMAX#(MAXLAT#,DGWLL#(I%,1))
	NEXT I%
	DGWLL#(5,1)=MINLAT#
	DGWLL#(5,2)=CM#
	ZONE%=0
	FOR I%=1 TO 5
		GEOG#(2)=DGWLL#(I%,1)
		GEOG#(1)=DGWLL#(I%,2)
		JOB%=1
		CALL PROJECT(GEOG#(),PROJ#(),ZONE%,PTYP%,JOB%,DARRAY#())
		DBWXY#(I%,1)=PROJ#(1)
		DBWXY#(I%,2)=PROJ#(2)
	NEXT I%
'open up the digitizer
1690	ECODE%=0
	ON ERROR GOTO 8260                 'TRAP ROUTINE
	OPEN DIGITIZER$ AS #1
	ON ERROR GOTO 0
	IF ECODE<>0 GOTO 1690
1691	PRINT "ENTER 0(ZERO) KEY ON CURSOR KEYPAD TO SYNCHRONIZE DIGITIZER INPUT"
	CALL GetDigitizer(ICH$,XBOARD,YBOARD,ICHR$(),OCHR$(),CPOS%,CWID%, _
		XPOS%,XWID%,YPOS%,YWID%,XUNIT,YUNIT,DIGKEY%)
	BEEP
	IF ICH$<>"0" GOTO 1691 
	PRINT "ENTER NORTHWEST CORNER ON DIGITIZER"
	CALL GetDigitizer(ICH$,XBOARD,YBOARD,ICHR$(),OCHR$(),CPOS%,CWID%, _
	XPOS%,XWID%,YPOS%,YWID%,XUNIT,YUNIT,DIGKEY%)
	DGW(1,1)=XBOARD
	DGW(1,2)=YBOARD
	BEEP
	PRINT "ENTER SOUTHWEST CORNER ON DIGITIZER"
	CALL GetDigitizer(ICH$,XBOARD,YBOARD,ICHR$(),OCHR$(),CPOS%,CWID%, _
		XPOS%,XWID%,YPOS%,YWID%,XUNIT,YUNIT,DIGKEY%)
	DGW(2,1)=XBOARD
	DGW(2,2)=YBOARD
	BEEP
	PRINT "ENTER SOUTHEAST CORNER OF DIGITIZER"
	CALL GetDigitizer(ICH$,XBOARD,YBOARD,ICHR$(),OCHR$(),CPOS%,CWID%, _
		XPOS%,XWID%,YPOS%,YWID%,XUNIT,YUNIT,DIGKEY%)
	DGW(3,1)=XBOARD
	DGW(3,2)=YBOARD
	BEEP
	PRINT "ENTER NORTHEAST CORNER ON DIGITIZER"
	CALL GetDigitizer(ICH$,XBOARD,YBOARD,ICHR$(),OCHR$(),CPOS%,CWID%, _
		XPOS%,XWID%,YPOS%,YWID%,XUNIT,YUNIT,DIGKEY%)
	DGW(4,1)=XBOARD
	DGW(4,2)=YBOARD
	BEEP
	XT=DGW(1,1)-DGW(2,1)
	YT=DGW(1,2)-DGW(2,2)
	IF XT<>0# THEN
		BETA=ATN(YT/XT)
	ELSE
		BETA=1.570796327#
	END IF
	XT=DBWXY#(1,1)-DBWXY#(2,1)
	YT=DBWXY#(1,2)-DBWXY#(2,2)
	IF XT<>0# THEN
		ALPHA=ATN(YT/XT)
	ELSE
		ALPHA=1.570796327#
	END IF
	CETA=BETA-ALPHA
	SINCETA=SIN(CETA):COSCETA=COS(CETA)
	XN=(DGW(3,1)-DGW(2,1))*COSCETA+(DGW(3,2)-DGW(2,2))*SINCETA
	YN=(DGW(1,2)-DGW(2,2))*COSCETA-(DGW(1,1)-DGW(2,1))*SINCETA
	SFX=(DBWXY#(3,1)-DBWXY#(2,1))/XN
	SFY=(DBWXY#(1,2)-DBWXY#(2,2))/YN
	DIFFPCT=ABS(((SFX-SFY)/SFX)*100.)
	IF DIFFPCT>2 THEN
		BEEP
		BEEP
		PRINT "SCALE DIFFERS BY MORE THAN 2 % IN X AND Y."
	END IF
	XT=ABS(39370.1*SFX)
	YT=ABS(39370.1*SFY)
	PRINT
	PRINT USING "X SCALE= ###########,.   Y SCALE= ###########,.";XT,YT
	PRINT
	CALL TTINAA(0,0,"CONTINUE? (Y/N) ",IANS$,"N","Y")
	IANS$=UCASE$(IANS$)
	IF IANS$="N" THEN
		TEMPWELL$=""
		GOTO 1971
	END IF
	X0R=DGW(2,1)
	Y0R=DGW(2,2)
'
' Start of loop per well location ended by cr
'

	CLS
	SOUND 1760,9.100001
1970	PRINT "ENTER WELL ID ";
	CALL GetParameterFromDigitizer(ND%,SAMP!,PUNT$,ICH$,XBOARD,YBOARD,ICHR$(),OCHR$(),CPOS%,CWID%, _
		XPOS%,XWID%,YPOS%,YWID%,XUNIT,YUNIT,DIGKEY%, _
		PREFIX$,SUFFIX$,LMASK%)
	IF PUNT$="Y" GOTO 1970
	IF LMASK%=0 GOTO 2570
	TEMP$=STR$(SAMP!)
	SAMP$=SPACE$(ND%+1)
	RSET SAMP$=TEMP$
	FOR I%=1 TO ND%+1
		IF MID$(SAMP$,I%,1)=" " THEN
			MID$(SAMP$,I%,1)="0"
		END IF 
	NEXT I%
	SAMP$=PREFIX$+MID$(SAMP$,2,ND%)+SUFFIX$
	PRINT SAMP$;
1971	IF SAMP$<>"" THEN
		CALL PAD(SAMP$,TEMPWELL$,12)
		DUP$="N"
		FOR I=1 TO NoOfWells
			J=I+1
			CALL ReadId(J,WellIdent$,TopElev,TotalDepth,StartingRecord,EndingRecord, _
				WellLat#,WellLon#,Bearing,Plunge)
			IF WellIdent$ = TEMPWELL$ THEN
				DUP$="Y"
				SAVJ=J
				GOTO 1975
			END IF
		NEXT I
		GOTO 1979
1975		SOUND 110,20.0
		PRINT
		PRINT "DUPLICATE WELL NUMBER ";TEMPWELL$
		CALL TTINAA(0,0,"DID YOU WANT TO REDIGITIZE THE LOCATION FOR THIS WELL?(Y/N): ",IDUM$,"","Y")
		IDUM$=UCASE$(IDUM$)
		IF IDUM$="Y" THEN
1979			WellIdent$=TEMPWELL$
			PRINT "          ENTER LOCATION ON DIGITIZER"
			CALL GetDigitizer(ICH$,XBOARD,YBOARD,ICHR$(),OCHR$(),CPOS%,CWID%, _
			XPOS%,XWID%,YPOS%,YWID%,XUNIT,YUNIT,DIGKEY%)
			BEEP
			IF ICH$<>"E" THEN
				XT=XBOARD-X0R
				YT=YBOARD-Y0R
				XD=XT*COSCETA+YT*SINCETA
				YD=YT*COSCETA-XT*SINCETA
				PROJ#(1)=DBWXY#(2,1)+SFX*XD
				PROJ#(2)=DBWXY#(2,2)+SFY*YD
				JOB%=2
'compute latitude-longitude from xy of current projection
				CALL PROJECT(GEOG#(),PROJ#(),ZONE%,PTYP%,JOB%,DARRAY#())
				WellLat#=GEOG#(2)
				WellLon#=GEOG#(1)
				IF DUP$="Y" THEN
					J=SAVJ
					CALL WriteId(J,WellIdent$,TopElev,TotalDepth,StartingRecord,EndingRecord, _
						WellLat#,WellLon#,Bearing,Plunge)
				ELSE
					TopElev=0
					TotalDepth=0
					StartingRecord=0
					EndingRecord=0
					NoOfWells=NoOfWells+1
					J=NoOfWells+1
					CALL WriteId(J,WellIdent$,TopElev,TotalDepth,StartingRecord,EndingRecord, _
						WellLat#,WellLon#,Bearing,Plunge)
					CALL WriteFirst(NoOfWells,FirstRecord,FinalRecord,NNV,TITLE$,DBWLL#())
				END IF
			END IF
'close files then re-open to capture data in buffers
			CLOSE #2,#3
			CALL OpenFiles(FILNAM$)
			CALL ReadFirst(NoOfWells,FirstRecord,FinalRecord,NNV,TITLE$,DBWLL#())
		END IF
		GOTO 1970
	END IF
'all done close digitizer and data files
2570	ERASE DGWLL#,ICHR$,OCHR$
	CLOSE #1,#2,#3
END SUB
SUB GetDigitizer(ICH$,XBOARD,YBOARD,ICHR$(1),OCHR$(1),CPOS%,CWID%, _
	XPOS%,XWID%,YPOS%,YWID%,XUNIT,YUNIT,DIGKEY%) STATIC
' INTERFACE TO DIGITIZER BOARD
2061	ON ERROR GOTO 7790
	ECODE%=0
        LINE INPUT #1,DSTRING$
	ON ERROR GOTO 0
	IF ECODE%=1 GOTO 2061
	FOR IJK%=1 TO DIGKEY%
		IF MID$(DSTRING$,CPOS%,CWID%)=ICHR$(IJK%) THEN
			ICH$=OCHR$(IJK%)
			GOTO 2063
		END IF
	NEXT IJK%
	ICH$=" "
2063	XBOARD=XUNIT*VAL(MID$(DSTRING$,XPOS%,XWID%))
	YBOARD=YUNIT*VAL(MID$(DSTRING$,YPOS%,YWID%))
END SUB
SUB GetParameterFromDigitizer(ND%,SAMP!,PUNT$,ICH$,XBOARD,YBOARD,ICHR$(1),OCHR$(1),CPOS%,CWID%, _
			XPOS%,XWID%,YPOS%,YWID%,XUNIT,YUNIT,DIGKEY%, _
			PREFIX$,SUFFIX$,LMASK%) STATIC 
'routine to get lcode, para1 or para2
		SAMP!=0
		PUNT$="N"
		FOR J%=1 TO ND%
			CALL GetDigitizer(ICH$,XBOARD,YBOARD,ICHR$(),OCHR$(),CPOS%,CWID%, _
			XPOS%,XWID%,YPOS%,YWID%,XUNIT,YUNIT,DIGKEY%)
			IF ICH$="E" THEN
				PUNT$="Y"
				GOTO GPFD1
			ELSEIF ICH$="A" THEN
				GOTO GPFD
			ELSEIF ICH$="C" THEN
				CSCR$=SPACE$(78)
				LOCATE 25,1
				PRINT CSCR$;
				LOCATE 25,1
				INPUT; "ENTER PREFIX: ",PREFIX$
				LOCATE 25,1
				PRINT CSCR$;
				LOCATE 25,1
				INPUT; "ENTER  NO. OF DIGITS: ",ND%
				LOCATE 25,1
				PRINT CSCR$;
				LOCATE 25,1
				INPUT; "ENTER SUFFIX: ",SUFFIX$
				LOCATE 25,1
				PRINT CSCR$;
				PUNT$="Y"
				LMASK%=LEN(PREFIX$)+ND%+LEN(SUFFIX$)
				GOTO GPFD1
			ELSE
				SAMP!=SAMP!*10 + VAL(ICH$)
			END IF
		NEXT J%
GPFD:		SOUND 261,6.5
GPFD1:
END SUB
